
set more off, perm
cd "..." /*specify your working directory*/

********************************************************************************
*   READ ME
********************************************************************************

/* Short description:
**********************

With the help of this dofile it is possible to convert the data structure of the CPDS 
from country-year to country-government structure. Please consider that the conversion only 
begins with the first cabinet for which a date of investiture is available. 

In the following do-file the variable "unemp" was used as an example. 
You can add the variables of interest in section "MERGE WITH STANDARD CPDS DATASET", as described.


You will need the following files:

- Comparative Political Data Set (in Stata form)
- Government Composition Data (as Excel file)
- Do file "do_help_COLLAPSE_GovernmentStructure.do"

These can be found on the website of the CPDS
http://www.cpds-data.org/index.php/data


Please cite as: 
***************
Klaus Armingeon, Sarah Engler and Lucas Leemann. 2022. 
Comparative Political Data Set 1960-2020. 
Zurich: Institute of Political Science, University of Zurich.

Klaus Armingeon, Sarah Engler and Lucas Leemann. 2022. 
Supplement to the Comparative Political Data Set â€" Government Composition 1960-2020. 
Zurich: Institute of Political Science, University of Zurich.

Corresponding adress: 
**********************
Angela Odermatt
angelacarmen.odermatt@uzh.ch

Authors: 
***********
Klaus Armingeon, Sarah Engler, Lucas Leemann

*/

********************************************************************************
*	IMPORT CPDS Government Dataset (Excel-Sheets) INTO STATA
********************************************************************************

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Australia") cellrange(A5:BA136) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Australia"
gen countryn = 1
order country countryn
qui save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Austria") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Austria"
gen countryn = 2
order country countryn
qui append using GovernmentComposition_data, force
qui save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Belgium") cellrange(A5:BA138) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Belgium"
gen countryn = 3
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Bulgaria") cellrange(A5:BA77) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Bulgaria"
gen countryn = 4
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Canada") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Canada"
gen countryn = 5
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Croatia") cellrange(A5:BA54) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Croatia"
gen countryn = 6
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Cyprus") cellrange(A5:BA104) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Cyprus"
gen countryn = 7
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Czech Republic") cellrange(A5:BA74) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Czech Republic"
gen countryn = 8
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Denmark") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Denmark"
gen countryn = 9
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Estonia") cellrange(A5:BA66) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Estonia"
gen countryn = 10
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Finland") cellrange(A5:BA142) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Finland"
gen countryn = 11
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("France") cellrange(A5:BA146) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "France"
gen countryn = 12
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Germany") cellrange(A5:BA134) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Germany"
gen countryn = 13
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Greece") cellrange(A5:BA147) firstrow clear 
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Greece"
gen countryn = 14
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Hungary") cellrange(A5:BA71) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Hungary"
gen countryn = 15
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Iceland") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Iceland"
gen countryn = 16
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Ireland") cellrange(A5:BA134) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Ireland"
gen countryn = 17
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Italy") cellrange(A5:BA153) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Italy"
gen countryn = 18
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Japan") cellrange(A5:BA145) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Japan"
gen countryn = 19
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Latvia") cellrange(A5:BA69) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Latvia"
gen countryn = 20
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Lithuania") cellrange(A5:BA69) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Lithuania"
gen countryn = 21
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Luxembourg") cellrange(A5:BA129) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Luxembourg"
gen countryn = 22
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Malta") cellrange(A5:BA116) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Malta"
gen countryn = 23
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Netherlands") cellrange(A5:BA137) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Netherlands"
gen countryn = 24
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("New Zealand") cellrange(A5:BA135) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "New Zealand"
gen countryn = 25
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Norway") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Norway"
gen countryn = 26
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Poland") cellrange(A5:BA104) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Poland"
gen countryn = 27
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Portugal") cellrange(A5:BA101) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Portugal"
gen countryn = 28
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Romania") cellrange(A5:BA97) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Romania"
gen countryn = 29
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Slovakia") cellrange(A5:BA75) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Slovakia"
gen countryn = 30
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Slovenia") cellrange(A5:BA71) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Slovenia"
gen countryn = 31
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Spain") cellrange(A5:BA94) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Spain"
gen countryn = 32
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Sweden") cellrange(A5:BA129) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Sweden"
gen countryn = 33
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("Switzerland") cellrange(A5:BA129) firstrow clear
replace C = "" if B == . 
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Switzerland"
gen countryn = 34
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("United Kingdom") cellrange(A5:BA133) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "United Kingdom"
gen countryn = 35
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government_Composition_1960-2020_Update_2022.xlsx", sheet("United States") cellrange(A5:BA143) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "United States"
gen countryn = 36
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

*** Order variables and sort observations
order country countryn
sort countryn investiture

*** Save dataset
save GovernmentComposition_data.dta, replace




********************************************************************************
*	CALCULATE YEARS OF INFLUENCE
********************************************************************************

***	Attributes the governments to years in which it effectively had influence

*** Definition: Number of months during teh first eight months of a year a cabinet needs 
*** to be in office to be counted as year of influence


*** Label variables
label var country "Country name"
label var countryn "Country number"
label var gov "Cabinet name"

*** Generate and format government variables
by countryn: gen govnr = _n
label var govnr "Government number (by country)"
by countryn: gen enddate = investiture[_n+1] - 1
format enddate %tdMonth_dd,_CCYY
label var enddate "Date of resignation"

*** Generate year variables
gen minyear = year(investiture)
label var minyear "Year of investiture"
gen maxyear = year(enddate)
label var maxyear "Year of resignation"

* measuring number of days of government was in power in their first year from January to August
gen start_day_of_year = doy(investiture)
gen end_day_of_year = doy(enddate)

*** We only count days from January to August
*
* August 31 is the 243rd day of the year 
replace start_day_of_year = 243 if start_day_of_year>243
gen tenure_in_days_1st_year = 243 - start_day_of_year


* Generate days in office in last year (maxyear) only during Jan-Aug
replace end_day_of_year = 243 if end_day_of_year>243
gen tenure_in_days_last_year = end_day_of_year

* Generate days in office in first year (minyear) only during Jan-Aug
replace tenure_in_days_last_year = end_day_of_year - start_day_of_year if minyear==maxyear 
replace tenure_in_days_1st_year = end_day_of_year - start_day_of_year if minyear==maxyear 


* Assign years in influence



gen yearinfluence1 = minyear
replace yearinfluence1 = . if maxyear<yearinfluence1


gen yearinfluence2 = yearinfluence1 + 1
replace yearinfluence2 = . if maxyear==yearinfluence1

gen yearinfluence3 = yearinfluence2 + 1
replace yearinfluence3 = . if maxyear==yearinfluence2

gen yearinfluence4 = yearinfluence3 + 1
replace yearinfluence4 = . if maxyear==yearinfluence3

gen yearinfluence5 = yearinfluence4 + 1
replace yearinfluence5 = . if maxyear==yearinfluence4

gen yearinfluence6 = yearinfluence5 + 1
replace yearinfluence6 = . if maxyear==yearinfluence5



* Some governments share the same minyear so we need to figure how whom to assign that year as influenceyear1

* to do so, we loop through countries and years
gen flagger = .
forvalues i = 1(1)36{
		forvalues y = 1961(1)2020{
			sum minyear if countryn==`i' & minyear==`y'
			gen flag_how_many = r(N)
			if flag_how_many>1{
				sum tenure_in_days_1st_year if countryn==`i' & minyear==`y' 
				gen day_counter_max = r(max)
				replace flagger = 1 if day_counter_max == tenure_in_days_1st_year & countryn==`i' & minyear==`y'
				
				* fix influence years for other governments with same minyear that do NOT get to count it for themselves
				quietly replace yearinfluence1 = yearinfluence2 if flagger!=1 & countryn==`i' & minyear==`y' 
				quietly replace yearinfluence2 = yearinfluence3 if flagger!=1 & countryn==`i' & minyear==`y' 
				quietly replace yearinfluence3 = yearinfluence4 if flagger!=1 & countryn==`i' & minyear==`y' 
				quietly replace yearinfluence4 = yearinfluence5 if flagger!=1 & countryn==`i' & minyear==`y' 
				quietly replace yearinfluence5 = yearinfluence6 if flagger!=1 & countryn==`i' & minyear==`y' 
				quietly replace yearinfluence6 = . if flagger!=1 & countryn==`i' & minyear==`y' 
				
				drop day_counter_max
				replace flagger = .
				di `i'
				di `y'
			}
			drop flag_how_many
		}
		
	}
		
drop if yearinfluence1==.
		
*Some government's last year is equal to another government's first year

egen maxyear_manipulated = rowmax(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6)
egen minyear_manipulated = rowmin(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6)



	gen new_govnr=.
	bysort countryn: replace new_govnr=_n

	forvalues i = 1(1)36{
			sum new_govnr if countryn==`i', meanonly 
			local max_govnr = r(max) 
			gen flag1 = 0
			gen flag2 = 0
			forvalues g = 2(1)`max_govnr' {  /* We are now looping through all governments of country i */
		
				* flag2 indicates whether first year of new government overlaps with last year of preceeding government
				quietly replace flag2 = 0
				quietly replace flag2 = 1  if minyear_manipulated == maxyear_manipulated[_n-1] & countryn==`i' & new_govnr==`g'
				* flag1 indicates if new government's tenure was longer in its first year than last government's tenure in its last year
				quietly replace flag1 = 0 
				quietly replace flag1 = 1 if tenure_in_days_1st_year>tenure_in_days_last_year[_n-1] & countryn==`i' & new_govnr==`g'

		
					replace maxyear_manipulated = maxyear-1 if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1
					replace yearinfluence1 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence1==maxyear
					replace yearinfluence2 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence2==maxyear
					replace yearinfluence3 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence3==maxyear
					replace yearinfluence4 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence4==maxyear
					replace yearinfluence5 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence5==maxyear
					replace yearinfluence6 = . if countryn==`i' & new_govnr==`g'-1 & flag1[_n+1]==1 & flag2[_n+1]==1 & yearinfluence6==maxyear
			
			
					replace minyear_manipulated = minyear+1 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence1 = yearinfluence2 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence2 = yearinfluence3 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence3 = yearinfluence4 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence4 = yearinfluence5 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence5 = yearinfluence6 if countryn==`i' & new_govnr==`g' & flag1==0 & flag2==1
					replace yearinfluence6 = . if countryn==`i' & govnr==`g' & new_govnr==`g' & flag1==0 & flag2==1
			}
			drop flag1 flag2
		}
	

	
* drop double years
replace yearinfluence2=. if  yearinfluence1== yearinfluence2
replace yearinfluence3=. if  yearinfluence2== yearinfluence3
replace yearinfluence4=. if  yearinfluence3== yearinfluence4
replace yearinfluence5=. if  yearinfluence4== yearinfluence5
replace yearinfluence6=. if  yearinfluence5== yearinfluence6
	
	
* Special case in Greece 1973 and 1974
gen yearinfluence7=.
gen yearinfluence8=.

replace yearinfluence6=1972 if countryn==14 & govnr==12
replace yearinfluence7=1973 if countryn==14 & govnr==12
replace yearinfluence8=1974 if countryn==14 & govnr==12
replace yearinfluence1=. if countryn==14 & govnr==13		
	

* UK, 1997 (equal numbr of days, goes to newer government)
replace yearinfluence1=1997 if countryn==35 & govnr==13	
replace yearinfluence2=1998 if countryn==35 & govnr==13	
replace yearinfluence3=1999 if countryn==35 & govnr==13	
replace yearinfluence4=2000 if countryn==35 & govnr==13	
replace yearinfluence5=2001 if countryn==35 & govnr==13	
replace yearinfluence6=. if countryn==35 & govnr==12	



* Greece, 1990
replace yearinfluence1=. if countryn==14 & govnr==21


*** Label influence year variables
label var yearinfluence1 "1st year of influence"
label var yearinfluence2 "2nd year of influence"
label var yearinfluence3 "3rd year of influence"
label var yearinfluence4 "4th year of influence"
label var yearinfluence5 "5th year of influence"
label var yearinfluence6 "6th year of influence"
label var yearinfluence7 "7th year of influence"
label var yearinfluence8 "8th year of influence"

*** Drop observations beyond data time frame
replace yearinfluence1=. if yearinfluence1>2020
replace yearinfluence2=. if yearinfluence2>2020
replace yearinfluence3=. if yearinfluence3>2020
replace yearinfluence4=. if yearinfluence4>2020
replace yearinfluence5=. if yearinfluence5>2020
replace yearinfluence6=. if yearinfluence6>2020
replace yearinfluence7=. if yearinfluence7>2020
replace yearinfluence8=. if yearinfluence8>2020



***	Ordering variables
sort countryn govnr
*sort gov
order country countryn govnr gov investiture enddate minyear maxyear days ///
	yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6 ///
	yearinfluence7 yearinfluence8 enddate
	
	
*** Generate variable for number of influence years
egen influenceyears = rownonmiss(yearinfluence1-yearinfluence8) 
label var influenceyears "Number of influence years of a government"

***	Saving data set
drop if yearinfluence1==.
save GovernmentComposition_data2.dta, replace

drop if yearinfluence1==.

	
export delimited using "GovernmentComposition_data2_stata", replace


*******************************************
*	MERGE WITH STANDARD CPDS DATASET
*******************************************


***	MERGE WITH GOVERNMENT-STRUCTURE DATA SET:
egen minyearinfluence = rowmin(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6 yearinfluence7 yearinfluence8)
egen maxyearinfluence = rowmax(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6 yearinfluence7 yearinfluence8)
expand 8
sort countryn govnr
by countryn govnr: gen govyearnr = _n
sort countryn govnr govyearnr gov
gen year = minyearinfluence
replace year = year + (govyearnr - 1)
drop if year > maxyearinfluence
replace country = "USA" if country == "United States"



merge m:m country year using "CPDS_1960-2020_Update_2022.dta", /// 
	keepusing(country year unemp) nogen // add here all variables of interest from the CPDS (or merge with further data of interest)
drop if countryn == .

***	Prepare variables of interest (unemp as example)
*** 1. Generate variables for each year of influence
gen unemp_y1 = unemp if yearinfluence1 != .
gen unemp_y2 = unemp if yearinfluence2 != .
gen unemp_y3 = unemp if yearinfluence3 != .
gen unemp_y4 = unemp if yearinfluence4 != .
gen unemp_y5 = unemp if yearinfluence5 != .
gen unemp_y6 = unemp if yearinfluence6 != .
gen unemp_y7 = unemp if yearinfluence7 != .
gen unemp_y8 = unemp if yearinfluence8 != .

*** 2. Drop missings 
drop if year < minyearinfluence & minyearinfluence != .
drop if year > maxyearinfluence & maxyearinfluence != .

*** 3. Assign variable value for each year of influence
sort countryn govnr year
by countryn govnr: replace unemp_y2 = unemp[_n+1] if yearinfluence2 != .
by countryn govnr: replace unemp_y3 = unemp[_n+2] if yearinfluence3 != .
by countryn govnr: replace unemp_y4 = unemp[_n+3] if yearinfluence4 != .
by countryn govnr: replace unemp_y5 = unemp[_n+4] if yearinfluence5 != .
by countryn govnr: replace unemp_y6 = unemp[_n+5] if yearinfluence6 != .
by countryn govnr: replace unemp_y7 = unemp[_n+6] if yearinfluence7 != .
by countryn govnr: replace unemp_y8 = unemp[_n+7] if yearinfluence8 != .
egen unemp_avg = rowmean(unemp_y1-unemp_y8)

*** Run step 1 to 3 for each variable of interest

*** Drop missings 
drop if year > yearinfluence1 & yearinfluence1 != .
drop if govnr == 0 | govnr == .

*** Drop auxiliary variables
capture drop year unemp govyearnr flagger

*** Order dataset 
order country countryn govnr gov investiture enddate minyear maxyear  ///
	days influenceyears yearinfluence1-yearinfluence8 unemp*
sort countryn govnr

*** Saving cabinet-dataset
*export delimited using "cpds_by_government_stata", replace 
outsheet using "cpds_by_government_stata", delimiter(";") replace
saveold cpds_by_government_stata.dta,  version(12) replace



***	END OF DO-FILE ***