version 15.0
set more off, perm
cd "directory_name"// enter your directory

********************************************************************************
*   READ ME
********************************************************************************

/* Short description:
**********************

With the help of this dofile it is possible to convert the data structure of the CPDS 
from country-year to country-government structure. Please consider that the conversion only 
begins with the first cabinet for which a date of investiture is available. 

In the following do-file the variable "unemp" was used as an example. 
You can add the variables of interest in section "MERGE WITH STANDARD CPDS DATASET", as described.


You will need the following files:

- Comparative Political Data Set (in Stata form)
- Government Composition Data (as Excel file)
- Do file "do_help_COLLAPSE_GovernmentStructure.do"

These can be found on the website of the CPDS
http://www.cpds-data.org/index.php/data


Pleas cite as: 
***************
Armingeon, Klaus, Virginia Wenger, Fiona Wiedemeier, Christian Isler, Laura Knoepfel, David Weisstanner and Sarah Engler. 2017.
Comparative Political Data Set 1960-2015.
Bern: Institute of Political Science, University of Berne.

Armingeon, Klaus, Virginia Wenger, Fiona Wiedemeier, Christian Isler, Laura Knoepfel and David Weisstanner. 2017.
Supplement to the Comparative Political Data Set - Government Composition 1960-2015.
Bern: Institute of Political Science, University of Berne.

Corresponding adress: 
**********************
virgina.wenger@ipw.unibe.ch

Authors: 
***********
Klaus Armingeon, David Weisstanner, Philipp Lutz, Virginia Wenger

*/

********************************************************************************
*	IMPORT CPDS Government Dataset (Excel-Sheets) INTO STATA
********************************************************************************

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Australia") cellrange(A5:BA125) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Australia"
gen countryn = 1
order country countryn
qui save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Austria") cellrange(A5:BA119) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Austria"
gen countryn = 2
order country countryn
qui append using GovernmentComposition_data, force
qui save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Belgium") cellrange(A5:BA126) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Belgium"
gen countryn = 3
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Bulgaria") cellrange(A5:BA66) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Bulgaria"
gen countryn = 4
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Canada") cellrange(A5:BA121) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Canada"
gen countryn = 5
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Croatia") cellrange(A5:BA43) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Croatia"
gen countryn = 6
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Cyprus") cellrange(A5:BA93) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Cyprus"
gen countryn = 7
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Czech Republic") cellrange(A5:BA65) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Czech Republic"
gen countryn = 8
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Denmark") cellrange(A5:BA121) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Denmark"
gen countryn = 9
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Estonia") cellrange(A5:BA55) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Estonia"
gen countryn = 10
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Finland") cellrange(A5:BA129) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Finland"
gen countryn = 11
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("France") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "France"
gen countryn = 12
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Germany") cellrange(A5:BA123) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Germany"
gen countryn = 13
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Greece") cellrange(A5:BA135) firstrow clear 
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Greece"
gen countryn = 14
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Hungary") cellrange(A5:BA60) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Hungary"
gen countryn = 15
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Iceland") cellrange(A5:BA120) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Iceland"
gen countryn = 16
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Ireland") cellrange(A5:BA123) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Ireland"
gen countryn = 17
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Italy") cellrange(A5:BA140) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Italy"
gen countryn = 18
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Japan") cellrange(A5:BA135) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Japan"
gen countryn = 19
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Latvia") cellrange(A5:BA59) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Latvia"
gen countryn = 20
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Lithuania") cellrange(A5:BA59) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Lithuania"
gen countryn = 21
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Luxembourg") cellrange(A5:BA119) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Luxembourg"
gen countryn = 22
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Malta") cellrange(A5:BA105) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Malta"
gen countryn = 23
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Netherlands") cellrange(A5:BA124) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Netherlands"
gen countryn = 24
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("New Zealand") cellrange(A5:BA123) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "New Zealand"
gen countryn = 25
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Norway") cellrange(A5:BA121) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Norway"
gen countryn = 26
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Poland") cellrange(A5:BA90) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Poland"
gen countryn = 27
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Portugal") cellrange(A5:BA90) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Portugal"
gen countryn = 28
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Romania") cellrange(A5:BA78) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Romania"
gen countryn = 29
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Slovakia") cellrange(A5:BA64) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Slovakia"
gen countryn = 30
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Slovenia") cellrange(A5:BA61) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Slovenia"
gen countryn = 31
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Spain") cellrange(A5:BA83) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Spain"
gen countryn = 32
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Sweden") cellrange(A5:BA119) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Sweden"
gen countryn = 33
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("Switzerland") cellrange(A5:BA119) firstrow clear
replace C = "" if B == . 
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "Switzerland"
gen countryn = 34
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("United Kingdom") cellrange(A5:BA120) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "United Kingdom"
gen countryn = 35
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

import excel "Government-Composition-1960-2015-Update-2017.xlsx", sheet("United States") cellrange(A5:BA131) firstrow clear
do do_help_COLLAPSE_GovernmentStructure.do
gen country = "United States"
gen countryn = 36
qui append using GovernmentComposition_data, force
save GovernmentComposition_data.dta, replace

*** Order variables and sort observations
order country countryn
sort countryn investiture

*** Save dataset
save GovernmentComposition_data.dta, replace




********************************************************************************
*	CALCULATE YEARS OF INFLUENCE
********************************************************************************

***	Attributes the governments to years in which it effectively had influence

*** Number of months during a year a cabinet needs to be in office to be counted as year of influence
global months 6 
***	This ASSUMPTION can be changed by adapting the number of months i in which a government had to be in office

*** Label variables
label var country "Country name"
label var countryn "Country number"
label var gov "Cabinet name"

*** Generate and format government variables
by countryn: gen govnr = _n
label var govnr "Government number (by country)"
by countryn: gen enddate = investiture[_n+1] - 1
format enddate %tdMonth_dd,_CCYY
label var enddate "Date of resignation"

*** Generate year variables
gen minyear = year(investiture)
label var minyear "Year of investiture"
gen maxyear = year(enddate)
label var maxyear "Year of resignation"

***	GENERATE YEARS OF INFLUENCE OF A GOVERNMENT
forvalues i = $months(1)$months {
gen yearinfluence1 = minyear if year(enddate) == minyear & month(enddate) > `i' ///  
			| year(enddate) > minyear	//1st gov year: counts if government was in office for at least six month (begin of July)	
//		gen yearinfluence1 = minyear // year of investiture counted as year of influence independent of cabinet duration

gen yearinfluence2 = minyear+1 if year(enddate) == minyear+1 & month(enddate) > `i' ///
			| year(enddate) > minyear+1								// 2nd gov year: counts if a government was in office for at least six month (end of June)

gen yearinfluence3 = minyear+2 if year(enddate) == minyear+2 & month(enddate) > `i' ///
			| year(enddate) > minyear+2								// 3rd gov year: counts if a government was in office for at least six month (end of June)

gen yearinfluence4 = minyear+3 if year(enddate) == minyear+3 & month(enddate) > `i' ///
			| year(enddate) > minyear+3								// 4th gov year: counts if a government was in office for at least six month (end of June)

gen yearinfluence5 = minyear+4 if year(enddate) == minyear+4 & month(enddate) > `i' ///
			| year(enddate) > minyear+4								// 5th gov year: counts if a government was in office for at least six month (end of June)

gen yearinfluence6 = minyear+5 if year(enddate) == minyear+5 & month(enddate) > `i' ///
			| year(enddate) > minyear+5								// 6th gov year: counts if a government was in office for at least six month (end of June)
}
*** Label influence year variables
label var yearinfluence1 "1st year of influence"
label var yearinfluence2 "2nd year of influence"
label var yearinfluence3 "3rd year of influence"
label var yearinfluence4 "4th year of influence"
label var yearinfluence5 "5th year of influence"
label var yearinfluence6 "6th year of influence"

*** Drop observations beyond data time frame
replace yearinfluence2=. if yearinfluence2>2015
replace yearinfluence3=. if yearinfluence3>2015
replace yearinfluence4=. if yearinfluence4>2015
replace yearinfluence5=. if yearinfluence5>2015
replace yearinfluence6=. if yearinfluence6>2015

*** Generate variable for number of influence years
egen influenceyears = rownonmiss(yearinfluence1-yearinfluence6) 
label var influenceyears "Number of influence years of a government"

***	Ordering variables
sort countryn govnr
sort gov
order country countryn govnr gov investiture enddate minyear maxyear days influenceyears ///
	yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6 

***	Saving data set
save GovernmentComposition_data2.dta, replace



*******************************************
*	MERGE WITH STANDARD CPDS DATASET
*******************************************


***	MERGE WITH GOVERNMENT-STRUCTURE DATA SET:
egen minyearinfluence = rowmin(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6)
egen maxyearinfluence = rowmax(yearinfluence1 yearinfluence2 yearinfluence3 yearinfluence4 yearinfluence5 yearinfluence6)
expand 6
sort gov
by gov: gen govyearnr = _n
by gov: gen noinfluence = _n if influenceyears == 0
sort countryn govnr govyearnr gov
gen year = year(investiture)
replace year = year + (govyearnr - 1)
drop if year > year(enddate)
replace country = "USA" if country == "United States"
merge m:m country year using "CPDS-1960-2015-Update-2017.dta", /// 
	keepusing(country year unemp) nogen // add here all variables of interest from the CPDS (or merge with further data of interest)
drop if countryn == .

***	Prepare variables of interest (unemp as example)
*** 1. Generate variables for each year of influence
gen unemp_y1 = unemp if yearinfluence1 != .
gen unemp_y2 = unemp if yearinfluence2 != .
gen unemp_y3 = unemp if yearinfluence3 != .
gen unemp_y4 = unemp if yearinfluence4 != .
gen unemp_y5 = unemp if yearinfluence5 != .
gen unemp_y6 = unemp if yearinfluence6 != .

*** 2. Drop missings 
drop if year < minyearinfluence & minyearinfluence != .
drop if year > maxyearinfluence & maxyearinfluence != .

*** 3. Assign variable value for each year of influence
sort gov
by gov: replace unemp_y2 = unemp[_n+1] if yearinfluence2 != .
by gov: replace unemp_y3 = unemp[_n+2] if yearinfluence3 != .
by gov: replace unemp_y4 = unemp[_n+3] if yearinfluence4 != .
by gov: replace unemp_y5 = unemp[_n+4] if yearinfluence5 != .
by gov: replace unemp_y6 = unemp[_n+5] if yearinfluence6 != .
egen unemp_avg = rowmean(unemp_y1-unemp_y6)

*** Run step 1 to 3 for each variable of interest

*** Drop missings 
drop if year > yearinfluence1 & yearinfluence1 != .
drop if noinfluence >= 1 & noinfluence != .
drop if govnr == 0 | govnr == .

*** Drop auxiliary variables
capture drop year unemp govyearnr noinfluence

*** Order dataset 
order country countryn govnr gov investiture enddate minyear maxyear  ///
	days influenceyears yearinfluence1-yearinfluence6 unemp*
sort countryn govnr

*** Saving cabinet-dataset
save cpds_by_government.dta, replace



***	END OF DO-FILE ***